unit Testunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, Buttons, StdCtrls, ExtCtrls, RtDbIni, DBTables,
  DBCtrls, Grids, DBGrids, Mask, Gauges;

type
  TForm1 = class(TForm)
    Database1: TDatabase;
    Panel1: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    RtDbIniFile1: TRtDbIniFile;
    Table1: TTable;
    Label2: TLabel;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    BitBtn2: TBitBtn;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Label3: TLabel;
    Label4: TLabel;
    EditValue: TEdit;
    ListBox1: TListBox;
    Table1FSECTION: TStringField;
    Table1FENTRY: TStringField;
    Table1FVALUE: TStringField;
    EditEntry: TEdit;
    EditSection: TEdit;
    RtGauge1: TGauge;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses
   Login, Rt;

{$R *.DFM}

function SqlLogin(Database: TDatabase; AliasName,UserName,Password: string): Boolean;
begin
   if Database.Connected then
      Database.Close;
   Database.AliasName := AliasName;
   Database.Params.Values['USER NAME'] := UserName;
   Database.Params.Values['PASSWORD'] := Password;
   Database.Open;
   Result := Database.Connected;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   Dir: array [0..255] of Char;
begin
   if not Database1.Connected then
   begin
      LoginForm := TLoginForm.Create(Application);
      try
         if LoginForm.ShowModal=idOK then
            try
               SqlLogin(Database1,LoginForm.Alias,LoginForm.User,LoginForm.Password);
            except
               if (not Database1.Connected) then
                  raise EDatabaseError.Create('Login fehlgeschlagen !');
            end;
      finally
         LoginForm.Release;
      end;
   end;
   GetWindowsDirectory(Dir,255);
   OpenDialog1.InitialDir := StrPas(Dir);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   if OpenDialog1.Execute then
      Edit1.Text := OpenDialog1.FileName;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
var
   Name,Section,Line: string;
   i: integer;
   S: TStringList;
begin
   if FileExists(Edit1.Text) then
   begin
      Name := ExtractFileName(Edit1.Text);
      i := Pos('.',Name);
      if i>0 then
         Name := Copy(Name,1,i-1);
      if Table1.Active then
         Table1.Close;
      {Table1.TableName := Name;}
      DataSource1.Enabled := False;
      RtDbIniFile1.Table := Table1;
      S := TStringList.Create;
      S.LoadFromFile(Edit1.Text);
      Section := '';
      try
         RtGauge1.MinValue := 0;
         RtGauge1.MaxValue := S.Count-1;
         RtGauge1.Progress := 0;
         RtGauge1.Visible := True;
         for i:=0 to S.Count-1 do
         begin
            RtGauge1.Progress := RtGauge1.Progress+1;
            Line := s[i]+#0;
            if not StrEmpty(@Line[1]) then
            begin
               if Line[1]='[' then
                  Section := StrExtract(@Line[2],']',1)
               else if Section<>'' then
                  RtDbIniFile1.WriteString(Section,StrExtract(@Line[1],'=',1),StrExtract(@Line[1],'=',2));
            end;
         end;
      finally
         RtGauge1.Visible := False;
         S.Free;
      end;
      Table1.Fields[0].Visible := False;
      Table1.Fields[1].DisplayLabel := 'Entry';
      Table1.Fields[2].DisplayLabel := 'Value';
      Table1.First;
      DataSource1.Enabled := True;
   end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   RtDbIniFile1.EraseSection(EditSection.Text);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
	RtDbIniFile1.ReadSection(EditSection.Text,ListBox1.Items);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
	RtDbIniFile1.ReadSectionValues(EditSection.Text,ListBox1.Items);
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
	EditValue.Text := IntToStr(RtDbIniFile1.ReadInteger(EditSection.Text,EditEntry.Text,0));
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
	EditValue.Text := IntToStr(Ord(RtDbIniFile1.ReadBool(EditSection.Text,EditEntry.Text,False)));
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
	EditValue.Text := RtDbIniFile1.ReadString(EditSection.Text,EditEntry.Text,'');
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
	RtDbIniFile1.WriteBool(EditSection.Text,EditEntry.Text,Boolean(StrToInt(EditValue.Text)));
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
	RtDbIniFile1.WriteInteger(EditSection.Text,EditEntry.Text,StrToInt(EditValue.Text));
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
	RtDbIniFile1.WriteString(EditSection.Text,EditEntry.Text,EditValue.Text);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
	Close;
end;

procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
begin
	with (Sender as TDataSource).Dataset do
   begin
		EditSection.Text := FieldByName('FSECTION').AsString;
		EditEntry.Text := FieldByName('FENTRY').AsString;
   end;
end;

end.
